"""initial schema

Revision ID: initial_schema
Revises: 
Create Date: 2024-01-01 00:00:00.000000

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision = 'initial_schema'
down_revision = None
branch_labels = None
depends_on = None

def upgrade() -> None:
    # Create stores table
    op.create_table(
        'stores',
        sa.Column('id', sa.String(50), primary_key=True),
        sa.Column('name', sa.String(100), nullable=False),
        sa.Column('type', sa.String(50), nullable=False),
        sa.Column('address', sa.Text),
        sa.Column('phone', sa.String(20)),
        sa.Column('email', sa.String(100)),
        sa.Column('contact_name', sa.String(100)),
        sa.Column('created_at', sa.DateTime, server_default=sa.func.now()),
        sa.Column('updated_at', sa.DateTime, server_default=sa.func.now(), onupdate=sa.func.now())
    )

    # Create customers table
    op.create_table(
        'customers',
        sa.Column('id', sa.Integer, primary_key=True),
        sa.Column('name', sa.String(100), nullable=False),
        sa.Column('phone', sa.String(20)),
        sa.Column('email', sa.String(100)),
        sa.Column('address', sa.Text),
        sa.Column('store_id', sa.String(50), sa.ForeignKey('stores.id')),
        sa.Column('created_at', sa.DateTime, server_default=sa.func.now()),
        sa.Column('updated_at', sa.DateTime, server_default=sa.func.now(), onupdate=sa.func.now())
    )

    # Create orders table
    op.create_table(
        'orders',
        sa.Column('id', sa.Integer, primary_key=True),
        sa.Column('order_number', sa.String(50), nullable=False, unique=True),
        sa.Column('type', sa.String(50), nullable=False),
        sa.Column('status', sa.String(50), nullable=False),
        sa.Column('date', sa.DateTime, server_default=sa.func.now()),
        sa.Column('week', sa.String(10)),
        sa.Column('statement_date', sa.DateTime),
        sa.Column('customer_id', sa.Integer, sa.ForeignKey('customers.id')),
        sa.Column('customer_name', sa.String(100)),
        sa.Column('customer_phone', sa.String(20)),
        sa.Column('customer_email', sa.String(100)),
        sa.Column('customer_address', sa.Text),
        sa.Column('store_id', sa.String(50), sa.ForeignKey('stores.id')),
        sa.Column('store_name', sa.String(100)),
        sa.Column('store_type', sa.String(50)),
        sa.Column('store_address', sa.Text),
        sa.Column('store_phone', sa.String(20)),
        sa.Column('store_email', sa.String(100)),
        sa.Column('store_contact_name', sa.String(100)),
        sa.Column('total', sa.Float, default=0.0),
        sa.Column('items', sa.Text),
        sa.Column('blankets', sa.Text),
        sa.Column('order_details', sa.Text),
        sa.Column('addons', sa.Text),
        sa.Column('blanket_type', sa.String(50)),
        sa.Column('blanket_size', sa.String(50)),
        sa.Column('blanket_color', sa.String(50)),
        sa.Column('blanket_condition', sa.String(50)),
        sa.Column('blanket_notes', sa.Text),
        sa.Column('statement_colours', sa.Text),
        sa.Column('selected_colours', sa.Text),
        sa.Column('saved_at', sa.DateTime, server_default=sa.func.now()),
        sa.Column('last_modified_at', sa.DateTime, server_default=sa.func.now(), onupdate=sa.func.now())
    )

    # Create invoices table
    op.create_table(
        'invoices',
        sa.Column('id', sa.Integer, primary_key=True),
        sa.Column('order_id', sa.Integer, sa.ForeignKey('orders.id')),
        sa.Column('invoice_number', sa.String(50), nullable=False, unique=True),
        sa.Column('date', sa.DateTime, server_default=sa.func.now()),
        sa.Column('due_date', sa.DateTime),
        sa.Column('total', sa.Float, nullable=False),
        sa.Column('hst_included', sa.Boolean, default=True),
        sa.Column('paid', sa.Boolean, default=False),
        sa.Column('created_at', sa.DateTime, server_default=sa.func.now()),
        sa.Column('updated_at', sa.DateTime, server_default=sa.func.now(), onupdate=sa.func.now())
    )

def downgrade() -> None:
    op.drop_table('invoices')
    op.drop_table('orders')
    op.drop_table('customers')
    op.drop_table('stores') 