-- Drop existing foreign key constraints if they exist
SET FOREIGN_KEY_CHECKS = 0;

-- Drop table if exists
DROP TABLE IF EXISTS invoices;

-- Create invoices table
CREATE TABLE invoices (
    id INT AUTO_INCREMENT PRIMARY KEY,
    pre_invoice_id INT,
    store_id VARCHAR(50),
    store_type VARCHAR(50) NOT NULL,
    month INT NOT NULL,
    year INT NOT NULL,
    total DECIMAL(10, 2) NOT NULL,
    status ENUM('draft', 'sent', 'paid', 'overdue', 'cancelled') NOT NULL DEFAULT 'draft',
    customer_id INT,
    due_date DATE,
    paid_date DATE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Create indexes for faster lookups
CREATE INDEX idx_invoices_store_id ON invoices(store_id);
CREATE INDEX idx_invoices_status ON invoices(status);
CREATE INDEX idx_invoices_dates ON invoices(due_date, paid_date);

-- Add foreign key constraints after table creation
ALTER TABLE invoices
ADD CONSTRAINT fk_invoices_store_id FOREIGN KEY (store_id) REFERENCES stores(id),
ADD CONSTRAINT fk_invoices_customer_id FOREIGN KEY (customer_id) REFERENCES customers(id),
ADD CONSTRAINT fk_invoices_pre_invoice_id FOREIGN KEY (pre_invoice_id) REFERENCES preInvoices(id);

SET FOREIGN_KEY_CHECKS = 1; 