import sqlite3

def check_sequences():
    conn = sqlite3.connect('data/athleticclean_M.db')
    cursor = conn.cursor()
    
    # Check order_sequence table
    print("Order Sequences:")
    cursor.execute('SELECT * FROM order_sequence')
    sequences = cursor.fetchall()
    for seq in sequences:
        print(f"Prefix: {seq[0]}, Last Number: {seq[1]}")
    
    # Check orders table
    print("\nRecent Orders:")
    cursor.execute('SELECT order_number FROM orders ORDER BY created_at DESC LIMIT 5')
    orders = cursor.fetchall()
    for order in orders:
        print(f"Order Number: {order[0]}")
    
    conn.close()

if __name__ == '__main__':
    check_sequences() 