from pydantic import BaseModel
from typing import List, Optional, Any

class OrderBlanketIn(BaseModel):
    order_id: int
    type: str
    weight: str
    quantity: int
    colors: List[str]
    blanket_type_id: int

    # Optional fields
    brand: Optional[str] = None
    is_plaid: Optional[bool] = False
    has_water_treatment: Optional[bool] = False
    has_hood: Optional[bool] = False
    has_heavy_soil: Optional[bool] = False
    has_heavy_hair: Optional[bool] = False
    has_repairs: Optional[bool] = False
    repair_minutes: Optional[int] = None
    repair_notes: Optional[str] = None
    blanket_quality_colour: Optional[str] = None
    base_price: Optional[float] = None
    is_double_weight: Optional[bool] = False
    dog_type: Optional[str] = None
    foal_mini_type: Optional[str] = None
    blanket_style: Optional[str] = None
    note_category: Optional[str] = None
    water_treatment_price: Optional[float] = None
    discount: Optional[Any] = None
    notes: Optional[str] = None
    no_wash: Optional[bool] = False
    pattern_notes: Optional[str] = None
    has_pattern: Optional[bool] = False
    red_flags: Optional[List[str]] = None

class OrderBlanketOut(OrderBlanketIn):
    id: int