# backend/app/models/order_sequence.py
from sqlalchemy import Column, Integer, String, DateTime, func
from ..database import Base

class OrderSequence(Base):
    """
    This table tracks the last used number for each order prefix (e.g., GH, I, HC)
    to prevent number collisions and gaps.
    """
    __tablename__ = "order_sequence"

    id = Column(Integer, primary_key=True, index=True)
    prefix = Column(String(10), unique=True, nullable=False)
    last_number = Column(Integer, nullable=False, default=99)
    created_at = Column(DateTime, server_default=func.now())
    updated_at = Column(DateTime, server_default=func.now(), onupdate=func.now())

    def __repr__(self):
        return f"<OrderSequence {self.prefix}{self.last_number}>"