# backend/app/models/order.py
from sqlalchemy import Column, Integer, String, DateTime, Text, ForeignKey, Boolean, Numeric
from sqlalchemy.orm import relationship
from ..database import Base
import datetime

class Order(Base):
    __tablename__ = "orders"

    id = Column(Integer, primary_key=True, index=True)
    order_number = Column(String(50), unique=True, nullable=False, index=True)
    status = Column(String(50), default='draft')
    date = Column(DateTime, default=datetime.datetime.utcnow)
    week = Column(String(10))
    
    customer_id = Column(Integer, ForeignKey("customers.id"))
    customer_name = Column(String(255))
    customer_phone = Column(String(50))
    customer_email = Column(String(255))
    customer_address = Column(String(255))
    customer_city = Column(String(100))
    customer_postal_code = Column(String(20))
    
    store_id = Column(String(255))
    store_name = Column(String(255))
    
    is_gh_staff_order = Column(Boolean, default=False)
    staff_name = Column(String(255))
    
    blankets = Column(Text) 
    order_colors = Column(Text)
    documents = Column(Text)
    
    total = Column(Numeric(10, 2), default=0.00)
    
    # --- ADD THESE TIMESTAMP COLUMNS ---
    created_at = Column(DateTime, default=datetime.datetime.utcnow)
    updated_at = Column(DateTime, default=datetime.datetime.utcnow, onupdate=datetime.datetime.utcnow)

    # --- Relationships ---
    customer = relationship("Customer", back_populates="orders")
    order_blankets = relationship("OrderBlanket", back_populates="order", cascade="all, delete-orphan")
