# /backend/app/models/admin_note.py
from sqlalchemy import Column, Integer, String, Text, Date, Enum, ForeignKey
from sqlalchemy.orm import relationship
from .base import Base
import enum

class NoteType(str, enum.Enum):
    """
    Enum for the different types of admin notes to categorize them in the database.
    """
    ADMIN = "admin"
    RED_FLAG = "red_flag"
    DISCOUNT = "discount"

class AdminNote(Base):
    __tablename__ = "admin_notes"

    id = Column(Integer, primary_key=True, index=True)
    
    # --- Foreign Keys to link the note to other records ---
    # The user_id is included to match your database schema. You can populate it
    # with the ID of the currently logged-in admin user.
    blanket_id = Column(Integer, ForeignKey("order_blankets.id"), nullable=False)
    customer_id = Column(Integer, ForeignKey("customers.id"), nullable=False)
    store_id = Column(String(50), ForeignKey("stores.id"), nullable=False)
    user_id = Column(Integer, ForeignKey("users.id"), nullable=False)

    # --- Note Details ---
    note = Column(Text, nullable=False)
    note_type = Column(Enum(NoteType), nullable=False, default=NoteType.ADMIN)
    note_date = Column(Date, nullable=False)

    # --- SQLAlchemy Relationships (optional but recommended) ---
    # These allow you to easily access related objects, e.g., `note.customer.name`
    customer = relationship("Customer")
    store = relationship("Store")
    blanket = relationship("OrderBlanket")
    user = relationship("User")

    def __repr__(self):
        return f"<AdminNote id={self.id} type='{self.note_type}'>"
